/*
 * Decompiled with CFR 0.152.
 */
package panther.util.unicon;

import panther.util.smalltalk.SimpleBlock;
import panther.util.unicon.GuaranteedActionImpl;
import panther.util.unicon.UniconThread;

public class GuaranteedActionLiberal
extends GuaranteedActionImpl {
    protected UniconThread actionThread;
    protected UniconThread timeLimitThread;
    protected boolean killActionThread = false;
    protected long actionSpawnTime;
    protected long actionStartTime;
    protected long timeLimitSpawnTime;
    protected long timeLimitStartTime;

    public GuaranteedActionLiberal(String string, long l, SimpleBlock simpleBlock) {
        this(string, l, simpleBlock, false);
    }

    public GuaranteedActionLiberal(String string, long l, SimpleBlock simpleBlock, boolean bl) {
        super(string, l, simpleBlock);
        this.actionThread = this.createActionThread(simpleBlock);
        this.timeLimitThread = this.createTimeLimitThread(l);
        this.killActionThread = bl;
    }

    public String toString() {
        return "GuaranteedActionLiberal " + this.number;
    }

    public void killActionThread() {
        this.killActionThread = true;
    }

    protected void terminateForError() {
        this.timeLimitThread.end();
    }

    protected void terminateForFinished() {
        this.timeLimitThread.end();
    }

    protected void terminateForInterrupt() {
        if (this.killActionThread) {
            this.actionThread.kill();
        }
        this.timeLimitThread.end();
    }

    protected void terminateForTimeout() {
        if (this.killActionThread) {
            this.actionThread.kill();
        }
    }

    protected void startThreads() {
        this.actionThread.setStartTime(this.runStartTime);
        this.timeLimitThread.setStartTime(this.runStartTime);
        this.actionSpawnTime = this.actionStartTime = System.currentTimeMillis();
        this.actionThread.start();
        this.timeLimitSpawnTime = this.timeLimitStartTime = System.currentTimeMillis();
        this.timeLimitThread.start();
    }

    protected UniconThread createActionThread(final SimpleBlock simpleBlock) {
        return new UniconThread("Action " + this.number){

            public void run() {
                try {
                    Object object = simpleBlock.evaluate();
                    GuaranteedActionLiberal.this.finished(object);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    GuaranteedActionLiberal.this.error(throwable);
                }
            }
        };
    }

    protected UniconThread createTimeLimitThread(long l) {
        UniconThread uniconThread = new UniconThread("TimeLimit " + this.number){

            public void run() {
                this.guaranteedSleep();
                if (this.continueRunning) {
                    GuaranteedActionLiberal.this.timeout();
                }
            }
        };
        uniconThread.setSleepTime(l);
        return uniconThread;
    }
}

